/**
 * Implementierung fr einen Binrbaum ber der Menge M=int
 * ausgehend vom Abstrakten Datentypen binaerbaum
 * aus der Vorlesung "Einfhrung in die Programmierung".
 *
 * Ein Binrbaum kann entweder leer sein oder besteht aus einem Datenelement
 * (hier aus der Grundmenge int) und einen rechten und linken Teilbaum.
 */

public class Binaerbaum implements Cloneable {

    //------------------------------------------------------------------------
    // Datenfelder

    private boolean istLeer;              // leerer Binrbaum?

    // die folgenden Datenfelder haben nur dann einen sinnvollen Wert,
    // wenn istLeer false ist
    private int datum;                    // Knotenelement
    private Binaerbaum linkerTeilbaum;    // linker Teilbaum
    private Binaerbaum rechterTeilbaum;   // rechter Teilbaum


    //------------------------------------------------------------------------
    // Methoden

    /**
     * entspricht emptytree()
     */
    Binaerbaum() {
	istLeer = true;	        // leerer Binrbaum
    }
    
    /**
     * entspricht maketree(l,a,r)
     */
    Binaerbaum(Binaerbaum l, int a, Binaerbaum r) {
	istLeer = false;	// kein leerer Binrbaum
	datum = a;              // Knotenelement
	linkerTeilbaum = l;     // linker Teilbaum
	rechterTeilbaum = r;    // rechter Teilbaum
    }

    /**
     * liefert das Knotenelement fr einen nichtleeren Binrbaum
     */
    int root() throws LeererBinaerbaumException {
	if(istLeer)
	    // Fehlerfall!
	    throw new LeererBinaerbaumException();
	else
	    return datum;
    }

    /**
     * liefert den linken Teilbaum fr einen nichtleeren Binrbaum
     */
    Binaerbaum lefttree() throws LeererBinaerbaumException {
	if(istLeer)
	    // Fehlerfall!
	    throw new LeererBinaerbaumException();
	else
	    return linkerTeilbaum;
    }

    /**
     * liefert den rechten Teilbaum fr einen nichtleeren Binrbaum
     */
    Binaerbaum righttree() throws LeererBinaerbaumException {
	if(istLeer)
	    // Fehlerfall!
	    throw new LeererBinaerbaumException();
	else
	    return rechterTeilbaum;
    }

    /**
     * testet auf leeren Baum
     */
    public boolean isemptytree() {
	return istLeer;
    }

    /**
     * testet, ob zwei Binrbume komponentenweise gleich sind
     */
    public boolean isequal(Binaerbaum t) {
	try {
	    if (isemptytree() & t.isemptytree())
		// beide Bume sind leer
		return true;
	    else if((isemptytree() & !t.isemptytree())
		    | (!isemptytree() & t.isemptytree()))
		// ein Baum ist leer, der andere nicht
		return false;
	    else
		// Rekursion
		return (root() == t.root())
		    & lefttree().isequal(t.lefttree())
		    & righttree().isequal(t.righttree());
	} catch (LeererBinaerbaumException e) {
	    // drfte nie vorkommen!
	    System.out.println(e.getMessage());
	    return false;
	}
    }

    /**
     * modifiziert das Knotenelement
     */
    public void setDatum(int neuesDatum) throws LeererBinaerbaumException {
	if(istLeer)
	    // Fehlerfall!
	    throw new LeererBinaerbaumException();
	else
	    // Knotenelement modifizieren
	    datum = neuesDatum;
    }

    /**
     * wandelt Binrbaum in String um
     */
    public String toString() {
	try {
	    if(isemptytree())
		return "<>";
	    else
		// Rekursive Ausgabe ber lefttree() und righttree()
		return "<" + lefttree() + "," + datum + "," + righttree() + ">";
	} catch(LeererBinaerbaumException e) {
	    System.out.println(e.getMessage());
	    return "darf nicht vorkommen";
	}
    }

    public Object clone() throws CloneNotSupportedException {
	// zuerst mal einfach kopieren
        Binaerbaum t = (Binaerbaum) super.clone();

	if(!istLeer) {
	    // fr Teilbume (nur beim nichtleerem Baum!) ist tiefe Kopie notwendig
	    t.linkerTeilbaum = (Binaerbaum)linkerTeilbaum.clone();
	    t.rechterTeilbaum = (Binaerbaum)rechterTeilbaum.clone();
	}

        return t;
    }

    public String inorder() throws LeererBinaerbaumException {
	if (!istLeer)
	    return lefttree().inorder() + " " + datum + righttree().inorder();
	else
	    return "";
    }

    public String preorder() throws LeererBinaerbaumException {
	if (!istLeer)
	    return  " " + datum + lefttree().preorder() + righttree().preorder();
	else
	    return "";
    }

    public String postorder() throws LeererBinaerbaumException {
	if (!istLeer)
	    return lefttree().postorder() + righttree().postorder() + " " + datum;
	else
	    return "";
    }

    public boolean contains (int i) throws LeererBinaerbaumException {
	if (istLeer)
	    return false;
	else
	    return (i == datum) || lefttree().contains(i) || righttree().contains(i);
    }

}

