public class Komplex {

    double re;
    double im;

    static String typ = "komplex";

    Komplex (double x, double y) {
	this.re = x;
	this.im = y;
    }
    
    public void setRe (double x) {
	this.re = x;
    }

    public void setIm (double y) {
	this.im = y;
    }

    public double getRe () {
	return this.re;
    }

    public double getIm () {
	return this.im;
    }

    public void drucken () {
	System.out.print ("(" + this.re + ", " + this.im + ")");
    }

    public void drucken (String s) {
	System.out.print (s); this.drucken ();
    }

    public void zeigeTyp () {
	System.out.print ("Typ: " + this.getTyp());
    }

    public String getTyp () {
	return this.typ;
    }

    public double [] toPolar () {
	// gibt fr ein bestehendes Objekt vom Typ Komplex ein Array zurck,
	// das die Polarkoordinaten enthlt
	double [] polar = new double [2];
	double r;
	double phi;
	r = StrictMath.sqrt(re*re + im*im);
	if (re > 0) { // 1. oder 4. Quadrant oder positive x-Achse
	    phi = StrictMath.atan (im/re);
	}
	else {
	    if (re < 0) {
		if (im < 0) { // 3. Quadrant
		    phi = - StrictMath.PI + StrictMath.atan (im/re);
		}
		else { // 2. Quadrant oder negative x-Achse
		    phi = StrictMath.PI - StrictMath.atan (im/(-re));
		}
	    }
	    else {
		if (im < 0) { // positive y-Achse
		    phi = -(StrictMath.PI)/2;
		}
		else { // negative y-Achse oder Nullpunkt
		    phi = StrictMath.PI/2;
		}
	    }
	}
	polar[0] = r;
	polar[1] = phi;
	return polar;
    }

    static Komplex toCart (double r, double phi) {
	// erzeugt aus zwei Parametern, die die Polarkoordinaten darstellen, 
	// ein Objekt vom Typ Komplex in kartesischen Koordinaten
	double a;
	double b;
	a = r*StrictMath.cos(phi);
	b = r*StrictMath.sin(phi);
	return new Komplex (a, b);
    }

} 
