package geometrie;

public class Strecke {

    Punkt a, b;

    public Strecke (Punkt a, Punkt b) {
	this.a = a;
	this.b = b;
    }

    public void setA (Punkt p) {
	this.a = p;
    }
	
    public void setB (Punkt p) {
	this.b = p;
    }
	
    public Punkt getA () {
	return this.a;
    }

    public Punkt getB () {
	return this.b;
    }
		
    public void drucken () {
	a.drucken ("1. Punkt: ");
	b.drucken ("2. Punkt: ");
    }

    public boolean hatEndpunkt (Punkt p) {
	return (this.a.istGleich (p) || this.b.istGleich (p));
    }
	
    public boolean istGleich (Strecke s) {
	return (s.hatEndpunkt (this.a) && s.hatEndpunkt (this.b));
    }
	
    public Punkt mittelPunkt () {
	double x, y;
	Punkt m;
	x = (this.getA().getX() + this.getB().getX()) / 2.0;
	y = (this.getA().getY() + this.getB().getY()) / 2.0;
	m = new Punkt(x, y);
	return m;
    }
	
    public Strecke spiegelnX () {
	Strecke s = new Strecke(this.getA(), this.getB());
	s.getA().spiegelnX();
	s.getB().spiegelnX();
	return s;
    }
	
    public Strecke spiegelnY () {
	Strecke s = new Strecke(this.getA(), this.getB());
	s.getA().spiegelnY();
	s.getB().spiegelnY();
	return s;
    }
		
    public double laenge () {
	return this.getA().dist(this.getB());
    }
}
